  {
This program produce radial distribution of the ED image
from Ratio images 
Before start of this program need to run General_RATany4.v

Output files: 2D arrays (coloumn corresponding to delay, and row to pixel number)
<Path\Radial_1D\TRED> - combined files of intensities at set of delays <FULL(LEFT,RIGHT)>.tif
<Path\Radial_1D\TRED> - corresponding combined files of 3x standard of average 
					    <sigmaFULL(sigmaLEFT,sigmaRIGHT)>.tif

Output files: 1D arrays
<Path\Radial_1D\RAW\> - files <F(L,R)><delay>.csv
<Path\Radial_1D\TRED> - combined files of intensities at set of delays <FULL(LEFT,RIGHT)>.csv
<Path\Radial_1D\TRED> - corresponding combined files of 3x standard of average 
					    <sigmaFULL(sigmaLEFT,sigmaRIGHT)>.csv

created 12/02/2001 by V.Lobastov Ver. 01.
}

const
  	 Prompt = 'Select an image for calculation' ;
		 	  P ='D:\UED3_Data_processed\Utilities\Delays\*.ini'; 		 	  //default directory for INI file
		  	  //	P ='D:\UED4_Data_raw\Utilities_UED4\Delays\*.ini'; 		 	 	  //default directory for INI file
	 	 
//------------> Global variables
var
	Data;
    F, L, R, T, B;					 			//field image variables for full, left, and right halves CCD}
    M, M_L, M_R, M_T, M_B;						// MASKS   
    Size_x, Size_y; 		  	 	  		 	//image size	 
    SamName;									//name of the file header   
    Fuss;										//image of the apparatus imperfections
	X0,Y0, RR;											
	im, imm; 	 	  	  	   	   		
	cur, curIm, curMask;						//index, current Image, current MASK
	FULL, LEFT, RIGHT;							//combined RAW 1D data
	sigmaFULL, sigmaLEFT, sigmaRIGHT;			//standard deviations for RAW 1D data
	difFULL, difLEFT, difRIGHT;		 			//combined difference 
	sdifFULL, sdifLEFT, sdifRIGHT;	 			//standard deviations for difference

//   Mask_II;                                     //Image Intensifier Mask Image}
//   Image_I;                                     //Input ED Image}

	 NS,NF, Combo;
	 Sel, delay, FL;
	 Sub, Out, Raw, InIMG;
	 Path, PathR, PathU, PathOUT;
	 Start, Loops, Crit;
	 AppMask;
{
******************************************************************
********************** function Select ***************************
******************************************************************
This function return a full file name for a file 
}	 	 

function SELECT;											
		var
   		   nName; Name, ix;
   		   Choice, nDIR;
		begin
	 		 Name:=FindFirstFile(P, fa_Archive);				  	 	 		//Find the first ini file in the delays directory 
	 		 nName:=ExtractFileName(Name);										//Convert the file name and the extension to a string
	 		 nDIR:= ExtractFilePath(Name);										//Return the drive and directory portions of a file name including the trailing backslash
			 ix:=0;																//initialize the variable ix to value of zero
	  		 
			 while StrLen(Name) > 0 do											//If there is a file in the directory, do

	  		 	   begin
	  	   		   		Name:=ExtractFileName(FindNextFile) ;					//Finde the next ini file in the delays directory
		   				nName:=nName+';'+Name;									//Augment the nName string with the next file name
					 if ix>100 then halt('Too many Files in Directory');   		//Stop, if there are more than 100 files
					 	ix:=ix+1;			  	   		 						//Increase the counter ix by 1
	 				end; 

	 			 if SelectString( 'Select File',nName , Choice ) >= 0 then		//If a selection among nName strings is made from the dialog box, then
	 			 	begin
			 			 SELECT:=nDIR+Choice;		  		   	 	  			//Initialize SELECT to the selected ini file
	 				end	
	 			else
	 				begin 
	 	 	  			  WriteInfo('No Selection made! Restart program! ');	//Inform the user that no selection was made
		 	  			  halt;					  						 		//abort the program
	 				end; 
		end;
//----------------------> end of function SELECT <-----------------------------------				

{
******************************************************************
********************** procedure HEADER **************************
******************************************************************
This procedure will generate header for output ASCII file
}

procedure HEADER(com, Head, RF);
   var
   	  im;
	  delay;
   begin
			Write(com,'pix'+RF);			   		 	 		  				//Write an expression to the output window without a terminating carriage-return
   		for im:=NS to NF do														//step through the number of delays
   	   		begin
				   delay:='delay'+Str(im);   									//define the delay number
					Write(com, ',', Head + ReadPrivateINIString( Sel, 'FileNames', delay));	 //write the delay name into the line
	   		end;
					WriteLn(com);		   						 	  			//write a carriage return
	end;	
//------------------> end of procedure HEADER <------------------------------------

{
******************************************************************
********************** procedure OUTRAT **************************
******************************************************************
This procedure will create output ASCII files in TXT format from
combined image contianing the array of 1D radial intensity data
}

procedure OUTRAT(FULLX,FNAME);

var
   Combo;
   jx, jjx, SX, NFX;

	begin
			SX:=GetXSize(FULLX);	   	  		 		   	   	  				//get the x dimension of the input array
			NFX:=GetYSize(FULLX);												//get the y dimension of the input array

				Combo:=CreateEditor('Out'+FNAME);        		 				//create an output window
				HEADER(Combo,'','');											//This procedure will generate header for output ASCII file
		for jjx:=0 to NFX-1 do													//step through the lines of the input array
     	 	begin		 
         		Write(Combo, Start+jjx) ;										//Write the radial pixel number
     				for jx:=0 to Integer(SX-1) do								//step through the columns of the input array
	 				 	 begin
         				 	  Write(Combo,',', FULLX[jx,jjx]:20:15) ;			//write the complete line into the output window
 						 end;
         					  WriteLn(Combo);						 			//terminate the line with a carriage return
			end;			 	 
				 Save(Combo, PathOUT + FNAME+FL+'.csv');						//save the output window as a *.csv file
				 Delete(Combo);		   											//delete the output window from the desktop
				 Delete(FULLX);													//delete the input array
	end;
//----------------------> end of procedure OUTRAT <-----------------



{
*************************************************************************************************
********************** procedure Radial(Image_I,Mask_II,R_Field, Flag) **************************
*************************************************************************************************
{This program produce 1D radial distribution from ED image with rejection of bad points}

procedure Radial(Image_I,Mask_II,R_Field, Flag);				 //Radial(curIm, curMask, F, 'F', cur});

var


//   Flag;   			 	 			 		// flag for FULL, LEFT, RIGHT
   D_Image, F_Image;                  			//Equal radii Mask images}
   Masked_F;
   Masked_FF;                        			//Masked ED Image}
   Num_pix;                                     //number of pixels at certain radius}
   F_pix;                                		//left and right halves}
   Rad_F;                       				//Output Sum of all pixels with equal radius}
   F_sum;                                       //variance image for left and rigth halves}
   FS;										 	//sums}
   F_std;                                 		//standard deviation for left and rigth halves}
   F_rej;								 		//Rejection filter}
   FR_pix;								 		//Number of pixels satisfying chosen criteria}
   FF; 										 	//Number of rejected pixels}
   Rad_FF;								 		//Corrected output sum for Radial distribution}
   Fmin, Fmax;
   Rad_sum;
   MM;
   iLoop;										//number of loops for rejection, loop index
   F_keep;
   Ed1;                                         //Output ASCII file}
   i, j;										//indices   

  begin
  
						 Data := CreateArray( single, 4, Size_x/2-Start) ;		//create an array
						 if IsNull( Data ) then		  	 				 		//if it failed
				Begin
						 WriteError( 'Insufficient memory to create array!' ) ;	//tell the user why
						 Halt;		 			   		  	 				  	//abort the program
				end
				else

          for i:=0 to Integer((Size_x)/2-1-Start) do							//step through the radii
           begin
		   
               F_Image := ( R_field > Start+i)  and (R_field <= Start+i+1) and (Mask_II) and (Fuss);  {binary ring mask of current radius}
					 
		  for iLoop:=1 to Loops do;			 				 			   	   	//step through the loops
		      		begin						 
                         F_pix:= Longint(SumOf(F_Image)); 	   	   			    //get the number of pixels in the ring mask image
                         Masked_FF:=Single(Image_I*F_Image);				    //mask the input diffraction image
	

                 if (F_pix = 0) then											//if there are no pixels left
                    begin
                         Rad_F:=0;												//mean count for current radius = 0
                         F_std:=0;												//STD for a current radius = 0
                    end
                 else
					begin

                        Rad_F:=Single(SumOf(Masked_FF)/F_pix); 	   				//mean count for current radius
                        F_sum:=Double(Masked_FF-F_Image*Rad_F);					//subtract the mean count from each pixel in the input diffraction image		
                        F_sum:=F_sum*F_sum;										//square the residuals
						FS:=SumOf(F_sum);										//sum the residuals
                        F_std:= Single(sqrt(FS/F_pix));							//STD for a current radius		

		 			end;	 

{----> calculation of "mean" and STD completed}

					   Fmin:=Rad_F-Crit*F_std; 									//define the minimum pixel value to keep in a given radius
					if Fmin<0 then Fmin:=0   ;									//the mimimum value cannot be negative
					   Fmax:=Rad_F+Crit*F_std;									//define the maximum pixel value to keep in a given radius

					   F_keep:=(Masked_FF< Fmax) and (Masked_FF> Fmin);			//create a binary mask image with pixels to keep
					   F_rej:= not F_keep; 		 	 			 				//create a binary mask image with pixels not to keep

					   FR_pix:= Word(SumOf(F_keep));							//new number of pixels for current radius
					   FF:=F_pix-FR_pix;                                    	//number of rejected pixels at current loop path
				   
{-----------> Calculate corrected radial distribution}

						Masked_FF:=Masked_FF*F_keep;  							//apply the new mask to the input diffraction image
						F_Image:=F_Image*F_keep;								//define the new mask
						F_pix:=FR_pix;											//redefine the number of pixels

                 if (FR_pix=0) then												//if there are no pixels left
                    begin
                         Rad_F:=0;												//mean count for current radius = 0
                         F_std:=0;											 	//STD for a current radius = 0
                    end
                    else

					begin
										
                        Rad_F:=Single(SumOf(Masked_FF)/F_pix);					//corrected mean for current radius}
                        F_sum:=Double(Masked_FF-F_Image*Rad_F);					//calculate new residuals
                        F_sum:=F_sum*F_sum;										//square them
						FS:=SumOf(F_sum);										//sum them
                        F_std:= Single(sqrt(FS/F_pix));							//updated STD for a current radius		
					end;	 
			
																														
                        WriteStatus('pix= ', Start+i, ' Rad_F= ', Rad_F, ' F_std= ', F_std, '   Rejected= ',FF);  //write the output in the info bar
						
			end;		

			
				Data[0,i]:=Start+i;		  	 		  		   	  		   		//the first column of the array contains the radial pixel information
				Data[1,i]:=Rad_F;												//the second column contains the mean intensity
//------> check for division by zero and calculate standard of average multiplied by factor of 3				
			if ((F_pix-1)= 0) then	 	 		   			   		   			//if the number of pixels in the radius is one
			  begin 
				Data[2,i]:=F_std/sqrt(F_pix);									//the second column is the standard deviation is the normal standard deviation
			  end
			  else				
				Data[2,i]:=3*F_std/sqrt(F_pix-1);								//otherwise the second column is 3 times the standard deviation of the mean 
				Data[3,i]:=F_pix;		 										//the third column is the number of pixels in the current radius
				
Free(F_sum);																	//Free memory
              end; 						 

{------> Free memory}

	Delete(D_Image); 					 										//Free memory
	Delete(Masked_FF);
	Delete(Masked_F);
	Delete(R_field);
	Delete(F_Image);

	
{---------> Create Output ASCII file}
    	 Ed1:=CreateEditor(Flag+SamName);										//Create an window for text output
          WriteLn(Ed1,'pix', ',', 'Mean', ',', 'MSEx3', ',', 'Npix') ;			//Write the title row
		  
     for j:=0 to Integer(Size_x/2-1-Start) do  				 		 			//go through all lines of the array data
	 begin
         Write(Ed1, ShortInt(Data[0,j]), ',', Data[1,j]:20:15, ',', Data[2,j]:20:15, ',', Integer(Data[3,j])) ;  //Write the contents of the array data
         WriteLn(Ed1);					 	  				   					//end with a blank line
 	 end;	 
		 Save(Ed1, Path+Sub+Raw + Flag + SamName + FL + '.csv');				//save the output as a *.csv file

		 Delete(Ed1);			  	   	 		   	  							//delete the output window from the desktop
end;
//---------------> End of procedure Radial <------------------------------

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

begin

//-----------------------> Initialization parameters<---------------------------------------

	 		Sel:=SELECT;												 // selector for initialization file

{------> Set Center coordinates}
						      				 	  						  
				 X0:=Val(ReadPrivateINIString( Sel, 'Center', 'cX'));	 //read a center coordinates for X
				 Y0:=Val(ReadPrivateINIString( Sel, 'Center', 'cY'));	 //read a center coordinates for Y
			
	 			 Path:= ReadPrivateINIString( Sel, 'Paths', 'Path');	 //read a base path
	 			 PathU:= ReadPrivateINIString( Sel, 'Paths', 'PathU');	 //read a path for Masks
				 PathR:=ReadPrivateINIString( Sel, 'Paths', 'PathR');	 //read a path for polar image				 	

//-------->get apparatus mask				 
				 AppMask:=ReadPrivateINIString( Sel, 'Images', 'AppMask'); 		//read the apparatus mask file name 
 		    	 Open(PathU + AppMask,Fuss);							 		//read the apparatus mask image from disk
				 
				 WriteInfo('Xcenter= '+Str(X0)+ '  Ycenter= '+Str(Y0));			//Display a dialog box containing an information message.
	
                 Size_x:=GetXSize(Fuss);		   								//read the x dimension of the image
                 Size_y:=GetYSize(Fuss);										//read the y dimension of the image

				 Crit:=Val(ReadPrivateINIString( Sel, 'Reject', 'Crit'));	 	//read the rejection criterium
				 Loops:=Val(ReadPrivateINIString( Sel, 'Reject', 'Loops'));	 	//read the number of loops

				 Start:=Val(ReadPrivateINIString( Sel, 'PixelStart', 'Start'));	//first pixel number 
				 NS:=Val(ReadPrivateINIString( Sel, 'TotalDelays', 'First'));	//first frame to process
				 NF:=Val(ReadPrivateINIString( Sel, 'TotalDelays', 'Last'));	//last frame to process
				 
				 				 		 
				 Sub:=ReadPrivateINIString( Sel, 'Paths', 'Sub');		 
				 if (StrLen(FindFirstFile( Path+Sub+'*.csv', fa_Archive)) = 0) then
				 CreateDir(Path+Sub);			 		  				  	   	//create subdirectory for output
				 	 			 
				 Out:=ReadPrivateINIString( Sel, 'Paths', 'Out');		 
				 PathOUT:=Path+Sub+Out;
				 if (StrLen(FindFirstFile( PathOUT+'*.csv', fa_Archive)) = 0) then				 
				 CreateDir(PathOUT);		 		  				 	   	  	//create directory for output

				 Raw:=ReadPrivateINIString( Sel, 'Paths', 'RAW');
				 if (StrLen(FindFirstFile( Path+Sub+Raw+'*.csv', fa_Archive)) = 0) then				 
				 CreateDir(Path+Sub+Raw);		 		  				 	   	//create directory for output 		
				 				 
				 InIMG:=ReadPrivateINIString( Sel, 'Paths', 'OutIMG');				 				 

//-----------------------> end of Initialization <------------------------------------------

//-----> polar image selection						  
						  RR:='X'+Str(Word(Round(10*X0)))+'y'+Str(Word(Round(10*Y0)));		//polar image file name				  
 		    		 	  Open(PathR + RR+'.tif',F);										//open the polar image, if it exists					  
						  WriteStatus('Selected polar image is ' + RR);						//Write Status 

{
//-----> create binary masks for LEFT, RIGHT, TOP, BOTTOM
						  
					 M:= CreateImage( Binary, Size_x, Size_y);
			         M:=0;
						  M_R:= M;
						  M_R[Integer(X0)..Size_x-1,0..Size_y-1]:=1;						//create the right mask
						  M_L:= not M_R;													//create the left mask
				   
						  L:=F*M_L;															//create the polar left mask
						  R:=F*M_R;															//create the polar right mask
Delete(M);				  																	//delete temporary files					  
Delete(M_L);
Delete(M_R);
}
//--------> create output array of 1D ratios 

 				FULL:=CreateArray(Single,NF-NS+1,size_x/2-Start);							//create arrays 
 				//LEFT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
 				//RIGHT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
				sigmaFULL:=CreateArray(Single,NF-NS+1,size_x/2-Start);						
 				//sigmaLEFT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
 				//sigmaRIGHT:=CreateArray(Single,NF-NS+1,size_x/2-Start);				
				
cur:=0;
	   //------> Browse trough files in directory defined in Path+InIMG
   for im:=NS to NF do
   	   begin   
			   delay:='delay'+Str(im);   
	   		   FL:=ReadPrivateINIString( Sel, 'FileNames', delay);
		 	   		
					Open(Path + InIMG + 'NR' + FL +'.tif',curIm); 			  	//open the ratio image
		 			Open(Path + InIMG +'NMR'+ FL +'.tif',curMask);				//open the mask image
					SamName:=FL;	  		  	 								//assign the filename to SamName

//-------------> create combined <1D radial in colomns>x<sequential number of processed data>
 
							Radial(curIm, curMask, F, 'F');						//This program produces 1D radial distribution from ED image with rejection of bad points
				   					FULL[cur,..]:=Data[1,..]; 					//transfer contents of data array to FULL array
							   sigmaFULL[cur,..]:=Data[2,..];					//transfer contents of data array to sigmaFULL array
		 							Delete(Data) ;

						{	Radial(curIm, curMask, L, 'L');
				   					LEFT[cur,..]:=Data[1,..]; 
							   sigmaLEFT[cur,..]:=Data[2,..];
		 							Delete(Data) ;							

							Radial(curIm, curMask, R, 'R');
				   					RIGHT[cur,..]:=Data[1,..]; 
							   sigmaRIGHT[cur,..]:=Data[2,..];
		 							Delete(Data) ;		}					
					cur:=cur+1;					 								//increase the counter by one (move to another delay)												
			end;

			Save(FULL, PathOUT+'FULL'+FL+'.tif');								//the array as an image
			//Save(LEFT, PathOUT+'LEFT'+FL+'.tif');								//the array as an image
			//Save(RIGHT, PathOUT+'RIGHT'+FL+'.tif');								//the array as an image
			
			Save(sigmaFULL, PathOUT+'sigmaFULL'+FL+'.tif');						//the array as an image
			//Save(sigmaLEFT, PathOUT+'sigmaLEFT'+FL+'.tif');						//the array as an image
			//Save(sigmaRIGHT, PathOUT+'sigmaRIGHT'+FL+'.tif');					//the array as an image

//-------------> create ASCII output from combined images 			

		 		OUTRAT(FULL,'FULL'); 	  		   								//create ASCII output from combined images
		 		//OUTRAT(LEFT,'LEFT');		 
		 		//OUTRAT(RIGHT,'RIGHT');

		 		OUTRAT(sigmaFULL,'sigmaFULL');
		 		//OUTRAT(sigmaLEFT,'sigmaLEFT');		 
		 		//OUTRAT(sigmaRIGHT,'sigmaRIGHT');


			        PlaySound( 'C:\Lib_V++\Mac.wav' ) ;							
					WriteInfo('Calculation completed!');

//------> free memory					
			Free(Fuss);						
			Free(FULL);
			//Free(LEFT);
			//Free(RIGHT);	
			Free(sigmaFULL);
			//Free(sigmaLEFT);
			//Free(sigmaRIGHT);	
end
